/*------------------------------------------------------------------------------
	[AppEvent.h]

	Copyright (C) 2004 Ki

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
------------------------------------------------------------------------------*/
#ifndef APP_EVENT_H_INCLUDED
#define APP_EVENT_H_INCLUDED


#include "TypeDefs.h"


enum
{
	APPEVENT_NONE = 0,
	APPEVENT_FILEDIALOG,
	APPEVENT_OPENGAME,
	APPEVENT_CHANGESCREENMODE,
	APPEVENT_CHANGESOUNDMODE,
	APPEVENT_RESET,
	APPEVENT_SAVESTATE,
	APPEVENT_LOADSTATE,
	APPEVENT_PARTIALMEMORYLOAD,
	APPEVENT_RECORD,
	APPEVENT_PLAYBACK,
	APPEVENT_REDRAWSCREEN,
	APPEVENT_TOGGLEFULLSCREEN,
	APPEVENT_EXIT,
	APPEVENT_SHOWMENU,
	APPEVENT_HIDEMENU,
	APPEVENT_TOGGLESIXBUTTONPAD,
	APPEVENT_CDROM_LOG,
	APPEVENT_HDWR_LOG,

	APPEVENT_PAUSE,
	APPEVENT_RUN,
	APPEVENT_TRACE_1,
	APPEVENT_TRACE_10,
	APPEVENT_TRACE_100,
	APPEVENT_TRACE_1000,
	APPEVENT_TRACE_10000,
	APPEVENT_ADVANCEFRAME_1,
	APPEVENT_ADVANCEFRAME_10,
	APPEVENT_ADVANCEFRAME_100,
	APPEVENT_SWITCH_MEMORYEDITOR,

	APPEVENT_SCREEN_X1,
	APPEVENT_SCREEN_X2,
	APPEVENT_SCREEN_X3,
	APPEVENT_SCREEN_X4,
	APPEVENT_SCREEN_FULLSCREEN,
	APPEVENT_SCREEN_STRETCHED,
	APPEVENT_SCREEN_SCANLINED,
	APPEVENT_SCREEN_HWACCEL,
	APPEVENT_SCREEN_SYNC_VBLANK,

	APPEVENT_INPUT_TWO_BUTTON_PAD,
	APPEVENT_INPUT_SIX_BUTTON_PAD,
	APPEVENT_INPUT_MOUSE,
	APPEVENT_INPUT_MULTI_TAP,
	APPEVENT_INPUT_MB128,

	APPEVENT_INPUT_CONFIGURE_PAD1,
	APPEVENT_INPUT_CONFIGURE_PAD2,
	APPEVENT_INPUT_CONFIGURE_PAD3,
	APPEVENT_INPUT_CONFIGURE_PAD4,
	APPEVENT_INPUT_CONFIGURE_PAD5,

	APPEVENT_AUDIO_SR96000,
	APPEVENT_AUDIO_SR88200,
	APPEVENT_AUDIO_SR64000,
	APPEVENT_AUDIO_SR48000,
	APPEVENT_AUDIO_SR44100,
	APPEVENT_AUDIO_SR32000,
	APPEVENT_AUDIO_SR22050,
	APPEVENT_AUDIO_SR11025,

	APPEVENT_AUDIO_SB4096,
	APPEVENT_AUDIO_SB3840,
	APPEVENT_AUDIO_SB3584,
	APPEVENT_AUDIO_SB3328,
	APPEVENT_AUDIO_SB3072,
	APPEVENT_AUDIO_SB2816,
	APPEVENT_AUDIO_SB2560,
	APPEVENT_AUDIO_SB2304,
	APPEVENT_AUDIO_SB2048,

	APPEVENT_AUDIO_SETVOLUME,

	APPEVENT_SAVE_BMP
};


typedef struct
{
	Sint32		screenWidth;
	Sint32		screenHeight;
	Sint32		bitsPerPixel;
	Sint32		magnification;
	BOOL		bFullScreen;
	BOOL		bScanLine;
	BOOL		bStretched;
	BOOL		bSync60HzScreen;
	BOOL		bHardwareAcceleration;
} ScreenModeArg;


typedef struct
{
	Sint32		bufferSize;
	Sint32		sampleRate;
	Sint32		overSampleRate;
	Sint32		masterVolume;
	BOOL		bReverb;
} SoundModeArg;


BOOL
APPEVENT_Init();

BOOL
APPEVENT_Deinit();


BOOL
APPEVENT_Set(
	const Sint32	event,
	const void*		pParam);

const
Sint32
APPEVENT_GetEventID();

const
void*
APPEVENT_GetParam(
	const Sint32	event);

void
APPEVENT_Ack();


#endif // APP_EVENT_H_INCLUDED
